<?php
// install/index.php - simple installer
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = $_POST['db_host'] ?? '127.0.0.1';
    $db_name = $_POST['db_name'] ?? '';
    $db_user = $_POST['db_user'] ?? '';
    $db_pass = $_POST['db_pass'] ?? '';
    $app_url = rtrim($_POST['app_url'] ?? 'https://b2b.kochitaxi.co.in', '/');

    $env = file_get_contents(__DIR__ . '/../.env.example');
    $env = preg_replace('/APP_URL=.*/', 'APP_URL=' . $app_url, $env);
    $env = preg_replace('/DB_HOST=.*/', 'DB_HOST=' . $db_host, $env);
    $env = preg_replace('/DB_DATABASE=.*/', 'DB_DATABASE=' . $db_name, $env);
    $env = preg_replace('/DB_USERNAME=.*/', 'DB_USERNAME=' . $db_user, $env);
    $env = preg_replace('/DB_PASSWORD=.*/', 'DB_PASSWORD=' . $db_pass, $env);

    file_put_contents(__DIR__ . '/../.env', $env);

    // import SQL
    $mysqli = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($mysqli->connect_error) {
        $error = 'DB connect error: ' . $mysqli->connect_error;
    } else {
        $sql = file_get_contents(__DIR__ . '/../database/schema_and_demo.sql');
        if ($sql === false) { $error = 'SQL read failed'; }
        else {
            $stmts = array_filter(array_map('trim', explode(';', $sql)));
            foreach ($stmts as $s) {
                if (strlen($s) > 5) $mysqli->query($s);
            }
            $success = true;
        }
    }
}
?>
<!doctype html><html><head><meta charset="utf-8"><title>Install Kochi Taxi B2B</title></head><body>
<h2>Install Kochi Taxi B2B</h2>
<?php if (!empty($error)): ?>
<div style="color:red;"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>
<?php if (!empty($success)): ?>
<div style="color:green;">Installation completed. Please remove /install for security and run `php artisan key:generate` on server (or set APP_KEY manually).</div>
<?php else: ?>
<form method="post">
App URL: <input name="app_url" value="https://b2b.kochitaxi.co.in" style="width:380px"><br><br>
DB Host: <input name="db_host" value="127.0.0.1"><br><br>
DB Name: <input name="db_name"><br><br>
DB User: <input name="db_user"><br><br>
DB Pass: <input name="db_pass" type="password"><br><br>
<button type="submit">Install</button>
</form>
<?php endif; ?>
</body></html>
